	function [S1, S2] = LATTICE_RICHARDS_H(alfa_odd, alfa_even, wT)
	
	% 	Computes the frequency response for the even and odd  
	%	branches in a lattice filter with cascaded first- and
	%	second-order Richards' (series sections) with symmetric adaptors. 
	%	The sections are cascaded using circulators. For bandpass and
	%	bandstop filters both S1 and S2 have even order.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar, 2010-10-08
	% 	Modified by: 	LW 2014-08-03	
	%	Copyright:		by authors - not released for commercial use
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	ewT = exp(i*wT);
	ewT2 = exp(i*wT*2);
	
	if mod(length(alfa_odd),2) == 1 	% Odd branch
		S1 = (1-alfa_odd(1)*ewT)./(ewT-alfa_odd(1));   % EQ(10.37)
		for k = 2:2:length(alfa_odd)-1
			a = alfa_odd(k+1)*(1-alfa_odd(k));
			S1 = -S1.*(-alfa_odd(k)*ewT2-a*ewT+1)./(ewT2-a*ewT-alfa_odd(k));
		end
	
		if length(alfa_odd) > length(alfa_even)
			S1 = -S1;
		end
	else		% BP or BS case
		S1 = 1;	
		for k = 1:2:length(alfa_odd)
			a = alfa_odd(k+1)*(1-alfa_odd(k));
			S1 = -S1.*(-alfa_odd(k)*ewT2-a*ewT+1)./(ewT2-a*ewT-alfa_odd(k));
		end
		if length(alfa_odd) < length(alfa_even)
			S1 = -S1;
		end 
	end
	% Even branch
	S2 = 1;
	for k = 1:2:length(alfa_even)
		a = alfa_even(k+1)*(1-alfa_even(k));
		S2 = -S2.*(-alfa_even(k)*ewT2-a*ewT+1)./(ewT2-a*ewT-alfa_even(k));
	end
